<?php

namespace app\pay\controller;

use service\PayService;

/**
 * Description of 优云宝
 *
 * @author Admin
 */
class YybPay extends PayService {

    /**
     * 优云宝 - 扫码支付 支付宝 微信 QQ钱包   QQ 153527561
     * @param string $trade_no 外部单号
     * @param string $subject 标题
     * @param float $totalAmount 支付金额
     */
    public function pay($trade_no, $subject, $totalAmount) {
        $order = $this->loadOrder($trade_no);
        if($order['status']==0){
            $appid  = $order->channelAccount->params->appid;
            $appkey = $order->channelAccount->params->appkey;
            $type   = $order->channelAccount->params->type;
			$beizhu   = $order->channelAccount->params->beizhu;
			
            $server   = 'http://yunpay.waa.cn';//优云宝服务器
            //回调地址
            $notifyurl = url("pay/YybPay/notify");

            $yundata = array(
                "appid"  => $appid,
                "data"   => $order['trade_no'],//网站订单号
                "money"  => round($totalAmount,2),//注意金额一定要格式化否则token会出现错误
                "type"   => $type,
                "uip"    => $this->getIp(),
            );

            $token = array(
                "appid"  =>  $yundata['appid'],//APPID号码
                "data"   =>  $yundata["data"],//数据单号
                "money"  =>  $yundata["money"],//金额
                "type"   =>  $yundata["type"],//类别
                "uip"    =>  $yundata['uip'],//客户IP
                "appkey" =>  $appkey//appkey密匙
            );

            $token = md5($this->urlparams($token));
            $postdata = $this->urlparams($yundata).'&token='.$token;
			if($yundata["type"]==1){
			   $alipayqr   = $order->channelAccount->params->alipayqr;
			}else{
			   $alipayqr = 0;
			}
            //启用本地备注模式
            if($yundata["type"]== 1 && $alipayqr == 1){//仅限支付宝
                $h5yundata = array("appid"=>$appid,"data"=>$yundata['data'],"money"=>$yundata['money'],"atype"=>1,"type"=>1);
                $h5token = array("appid"=>$appid,"data"=>$yundata['data'],"money"=>$yundata['money'],"type"=>1,"appkey" =>$appkey);
                $h5token = md5($this->urlparams($h5token));
                $h5postdata = $this->urlparams($h5yundata).'&token='.$h5token;
                $h5fdata = $this->curl_post_https($server.'/Alipay',$h5postdata);
                $h5sdata = json_decode($h5fdata, true);//将json代码转换为数组
		
                if($h5sdata['state']==1){
                    $h5sdata = $h5sdata['text'];
                $qrcode ='alipays://platformapi/startapp?appId=20000123&actionType=scan&biz_data={"s":"money","u": "'.$h5sdata['alipayid'].'","a": "'.$h5sdata['money'].'","m":"'.$h5sdata['data'].'"}';
                $sdata = array('state'=>1,'qrcode'=>$qrcode,'youorder'=>$yundata["data"],'data'=>$yundata["data"],'money'=>$yundata["money"],'times'=>time() + 300,'orderstatus'=>0,'text'=>10089); //本地生成二维码
                }else{
					 exit('请先启动优云宝收款软件并登录支付宝');
				}
               
            }else{
                //否则走云端
                $fdata = $this->curl_post_https($server,$postdata);//发送数据到网关
                $sdata = json_decode($fdata, true);//将json代码转换为数组
            }

            if(!$sdata) {
                exit('支付接口异常1');
            }
            if($sdata["state"]!==1){
                if($sdata["text"]==10013) {
                    exit('支付系统繁忙，请稍后再试');
                } elseif($sdata["text"]==10007) {
                    exit('支付系统到期，请续费！');
                } elseif($sdata["text"]==10008) {
                    exit('支付ID或密匙错误！');
                } elseif($sdata["text"]==10014) {
                    exit('二维码没有配置！');
                } elseif($sdata["text"]==10015) {
                    exit('支付系统繁忙！');
                } elseif($sdata["text"]==10016) {
                    exit('任意金额二维码已关闭！');
                } elseif($sdata["text"]==10017) {
                    exit('支付高峰期，超出并发限制');
                } elseif($sdata["text"]==10006) {
                    exit('支付ID错误');
                }else{
                    exit('支付接口异常2');
                }
            }
            if($type==1){
				$sdata['paytype'] ='支付宝';
				$sdata['color'] = '#1678ff';
			}
            if($type==2) {
				$sdata['paytype'] ='QQ钱包';
				$sdata['color'] = '#11b6f4';
			}
            if($type==3){
				$sdata['paytype'] ='微信支付';
				$sdata['color'] = '#22ab39';
			}

            if($this->isMobile()){
                $sdata['shebei'] = 1 ;
            }else{
                $sdata['shebei'] = 2 ;
            }
			
			$sdata['htime'] =  $sdata["times"] - time();
			$sdata['beizhu'] =  $beizhu;
			
            echo $this->template($sdata);
        }else{
            exit('订单有误');
        }
    }
   
    /**
     * 检查订单状态
     */

    public function callback_ajax() {
        $out_trade_no = input("data");
        $order = $this->loadOrder($out_trade_no);
        //print_r($order['status']);
        if($order['status']){
            echo '{"code":"1","msg":"ok"}';
        }else{
            echo '{"code":"0","msg":"no"}';
        }
        exit;
    }

    /**
     * 服务器回调
     */
    public function notify() {
		$order = $this->loadOrder(input("name"));
		if($order && $order['status']==0){
			$appkey = $order->channelAccount->params->appkey;
			$pass   = md5($order->channelAccount->params->pass);
			//生成签名
            $sing =md5('ddh='.input("ddh").'&name='.input("name").'&money='.input("money").'&key='.$appkey.'');
			if($sing == input("key")){
				if(input("pass")== $pass) {
					if($order['total_price']>= input('money')){
                        $order->transaction_id = input('name');
                        $this->completeOrder($order);
						exit('ok');
                    }else{
						exit('金额错误！');
					}
				}else{
					exit('充值密码错误');
				}	
			}else{
				exit('签名错误');
			}
		}else{
			exit('订单号错误,或者重复处理，ok');
		}
    }



//获取客户端IP地址
    public function getIp()
    { //取IP函数
        static $realip;
        if (isset($_SERVER)) {
            if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $realip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else {
                $realip = isset($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : $_SERVER['REMOTE_ADDR'];
            }
        } else {
            if (getenv('HTTP_X_FORWARDED_FOR')) {
                $realip = getenv('HTTP_X_FORWARDED_FOR');
            } else {
                $realip = getenv('HTTP_CLIENT_IP') ? getenv('HTTP_CLIENT_IP') : getenv('REMOTE_ADDR');
            }
        }
        $realip=explode(",",$realip);

        return $realip[0];
    }

//数组拼接为url参数形式
    public function urlparams($params){
        $sign = '';
        foreach ($params AS $key => $val) {
            if ($val == '') continue;
            if ($key != 'sign') {
                if ($sign != '') {
                    $sign .= "&";
                    //$urls .= "&";
                }
                $sign .= "$key=$val"; //拼接为url参数形式
            }
        }
        return $sign;
    }



    /* PHP CURL HTTPS POST */
    public function curl_post_https($url,$data){ // 模拟提交数据函数
        $curl = curl_init(); // 启动一个CURL会话
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); // 对认证证书来源的检查
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0); // 从证书中检查SSL加密算法是否存在
        curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // 使用自动跳转
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer
        curl_setopt($curl, CURLOPT_POST, 1); // 发送一个常规的Post请求
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data); // Post提交的数据包
        curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
        curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回
        $tmpInfo = curl_exec($curl); // 执行操作
        if (curl_errno($curl)) {
            echo 'Errno'.curl_error($curl);//捕抓异常
        }
        curl_close($curl); // 关闭CURL会话
        return $tmpInfo; // 返回数据，json格式
    }

    public function parseurl($url="")
    {
        $url = rawurlencode(mb_convert_encoding($url, 'gb2312', 'utf-8'));
        $a = array("%3A", "%2F", "%40");
        $b = array(":", "/", "@");
        $url = str_replace($a, $b, $url);
        return $url;
    }

    //手机浏览器判断
    public function isMobile()
    {
        // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
        if (isset ($_SERVER['HTTP_X_WAP_PROFILE']))
        {
            return true;
        }
        // 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
        if (isset ($_SERVER['HTTP_VIA']))
        {
            // 找不到为flase,否则为true
            return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
        }
        // 脑残法，判断手机发送的客户端标志,兼容性有待提高
        if (isset ($_SERVER['HTTP_USER_AGENT']))
        {
            $clientkeywords = array ('nokia',
                'sony',
                'ericsson',
                'mot',
                'samsung',
                'htc',
                'sgh',
                'lg',
                'sharp',
                'sie-',
                'philips',
                'panasonic',
                'alcatel',
                'lenovo',
                'iphone',
                'ipod',
                'blackberry',
                'meizu',
                'android',
                'netfront',
                'symbian',
                'ucweb',
                'windowsce',
                'palm',
                'operamini',
                'operamobi',
                'openwave',
                'nexusone',
                'cldc',
                'midp',
                'wap',
                'mobile'
            );
            // 从HTTP_USER_AGENT中查找手机浏览器的关键字
            if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT'])))
            {
                return true;
            }
        }

    }
	
	 //模板
    public function template($sdata){
        if($sdata['shebei']==1){
            $color = $sdata['color'];
            $class = '';
        }
        if($sdata['shebei']==2){
            $color = '#CCCCCC';
            $class = 'absoluteCenter';
        }

        $return = '
        <!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>请使用【'.$sdata['paytype'].'App】扫码支付</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <script type="text/javascript" src="/static/yybpay/jquery.min.js"></script>
    <script type="text/javascript" src="/static/yybpay/utf.js"></script>
    <script type="text/javascript" src="/static/yybpay/qrcode.js"></script>
    <style>
        body{margin-left:0;margin-top:0;margin-right:0;margin-bottom:0;background-color:'.$color.'}.text{margin:0 auto;font-size:16px;margin:0 auto;text-align:center;margin-top:20px;overflow:hidden;clear:both}.text .order{font-size:10px;color:#019fe8}.text .mx{margin:15px auto;padding:20px;margin-bottom:5px;background-color:#fff;color:#ff6000;font-size:14px;width:180px;border-radius:10px 10px 10px 10px}.text p{color:#033eff}.paypage-price{font-size:30px}.paypage-price-number{color:#ff1400}.paypage-price_text{font-size:16px;color:#0058f8}.paypage-time{font-size:20px;color:#0058f8}.paypage-time s{font-size:20px;color:#f80000}.time-item strong{background:#ff1400;color:#fff;font-size:12px;font-family:microsoft yahei;padding:2px 4px 2px 4px;margin-right:5px;border-radius:5px;box-shadow:1px 1px 3px rgba(0,0,0,0.2)}.order_pay_info{margin:0 auto;width:90%;margain-bottom：10px}.order_pay_info .m{padding:10px;margin-bottom:1px;color:#fff;font-family:"microsoft yahei";font-size:14px}.order_pay_infozz{margin:0 auto;width:90%;margain-bottom：10px}.order_pay_infozz .mm{padding:10px;margin-bottom:10px;border:1px solid;background-color:#fff4ea;border-color:#ffdbb8;color:#ff1400;font-family:"microsoft yahei";font-size:14px}.order_pay_title{margin:0 auto;width:100%}.order_pay_title_left{float:left;width:72%}.order_pay_title_right{float:right;width:28%}.order_pay_title_right .xm{margin:0 auto;padding:5px;margin-bottom:1px;border:1px solid;background-color:#fff;border-color:#ccc;color:#000;font-family:"microsoft yahei";font-size:14px;border-radius:0 0 0 10px;height:40px;margin:0 auto;text-align:center}.order_pay_title .m{padding:10px;margin-bottom:15px;border:0 solid;background-color:#fff;border-color:#bde9fd;color:#000;font-family:"microsoft yahei";font-size:14px}.absoluteCenter{width:400px;height:650px;margin:20px auto;border-radius:20px;border:10px solid;-moz-border-radius:10px;-webkit-border-radius:10px;-o-border-radius:10px;border-style:solid;border-color:#fff;background-color:'.$sdata['color'].'}.texdd{width:100px;height:30px;overflow:hidden;border:solid 1px #ccc;line-height:30px;padding-left:5px;border-radius:3px;color:#f00000;min-height:28px;background-color:#fff}
    </style></head>
<body>

<div class="'.$class.'">
<div class="order_pay_title">
    <div class="order_pay_title_left">
        <div class="m">请使用【<span style="color: #f00000">'.$sdata['paytype'].'App</span>】扫码支付</div>
    </div>
    <div class="order_pay_title_right">
        <div class="xm">二维码有效期<div class="time-item"><strong id="minute_show"><s></s>00分</strong> <strong id="second_show"><s></s>00秒</strong></div></div>
    </div>

</div>
<div class="text">

    <div class="mx">
        <div id="codeDiv" style="display: none;"></div>
        <div id="qrcode"></div>
        <div class="order">'.$sdata['data'].'</div>
    <div class="paypage-price"><span class="paypage-price-number">￥'.$sdata['money'].'</span> </div>
    </div>
    <div class="order_pay_info"><div class="m">注意：请付款<b>'.$sdata['money'].'</b>元，输入错误不发货</div></div>
	
	 <div class="order_pay_infozz">
            <div class="mm" style="color: #001c35">
               提示：'.$sdata['beizhu'].'
            </div>
        </div>
		
      
    <a class="texdd" href="/index/Pay/pay_result?orderid='.$sdata['data'].'">查看订单</a>
</div>
</div>
<script type="text/javascript">
 var qrcode = new QRCode("codeDiv", {
     text: \''.$sdata['qrcode'].'\',
     render: "canvas",  //渲染方式指定canvas方式
     width: 178,
     height: 178,
     typeNumber:-1,//计算模式
     colorDark : "#000000",
     colorLight : "#ffffff",
     correctLevel : QRCode.CorrectLevel.M
 });
 var canvas=document.getElementsByTagName(\'canvas\')[0];
 var img = convertCanvasToImage(canvas);
 $(\'#qrcode\').append(img);// 添加DOM

 //从 canvas 提取图片 image
 function convertCanvasToImage(canvas) {
     //新建Image对象
     var image = new Image();
     // canvas.toDataURL 返回的是一串Base64编码的URL
     image.src = canvas.toDataURL("image/png");
     return image;
 }

 function timer(){
     var intDiff = parseInt('.$sdata['htime'].');//倒计时总秒数量
     window.setInterval(function(){
         var day=0,
             hour=0,
             minute=0,
             second=0;//时间默认值
         if(intDiff > 0){
             day = Math.floor(intDiff / (60 * 60 * 24));
             hour = Math.floor(intDiff / (60 * 60)) - (day * 24);
             minute = Math.floor(intDiff / 60) - (day * 24 * 60) - (hour * 60);
             second = Math.floor(intDiff) - (day * 24 * 60 * 60) - (hour * 60 * 60) - (minute * 60);
         }
         if (minute == 00 && second == 00){
             $("#qrcode").empty();
             location.href = "/index/Pay/pay_result?orderid='.$sdata['data'].'";
         }
         if(minute == 00 && second < 10){
             layer.msg(\'还有\'+ second +\'秒超时\', {icon: 3});
         }
         if (minute <= 9) minute = \'0\' + minute;
         if (second <= 9) second = \'0\' + second;
         $(\'#day_show\').html(day+"天");
         $(\'#hour_show\').html(\'<s id="h"></s>\'+hour+\'时\');
         $(\'#minute_show\').html(\'<s></s>\'+minute+\'分\');
         $(\'#second_show\').html(\'<s></s>\'+second+\'秒\');
         intDiff--;

     }, 1000);

 }
     $(function(){
        timer();
    });
 function load_ajax() {
     var myform = new FormData();
     myform.append(\'data\',\''.$sdata['data'].'\');
     $.ajax({
         url: "/pay/yyb_pay/callback_ajax",
         type: "POST",
         data: myform,
         //async: false,
         contentType: false,
         processData: false,
         dataType: "json",
         success: function(data){
             setTimeout("load_ajax()", 3000);
             if (data.code == 1) {
                 location.href = "/index/Pay/pay_result?orderid='.$sdata['data'].'";
                 return ;
             }
         },
         error: function (data) {
             layer.msg(\'连接服务器失败！\');
             return ;
         }
     });
 }
 setTimeout("load_ajax()", 3000);

</script>

</body>
</html> 
        ';

        return $return;
    }
}


